

TITLE ' energy balance'
COORDINATES cartesian2
SELECT
!errlim=0.01
!fixdt ON


VARIABLES
Temp


DEFINITIONS
!kx  cp r

kx=0.5 {W/mC}
cp=1100 {J/kgC}
r=1600 {kg/m^3}



lc=8/1000 {m}
b=0.8/1000 {m}

hc=50 {W/m^2C}
!Tbound= 400
T0=298
rate=5 {K/min}
Tbound=min(T0+rate/60*t,343)

INITIAL VALUES
Temp=T0 {Initial conditions: constant temperature}

EQUATIONS
Temp:  r*cp*dt(Temp)=kx*dxx(Temp)+kx*dyy(Temp)

BOUNDARIES

Region 1

start (0,0)
!natural  (temp)=hc*(Temp-Tbound) line to (0,b)
Value (Temp)=Tbound line to (0,b)
natural (Temp)=0   line to (lc,b) {adiabatic}
Value (Temp)=Tbound line to (lc,0)
natural (Temp)=0 line to close  {adiabatic}


TIME  0 to 1000 by 0.1

MONITORS
for t=0 by 10 to 1000
Contour(Temp)

PLOTS
for t=0 by 10 to 1000
elevation(Temp-273) from (0,b/2) to (lc,b/2) as "Temperatura, C"
surface(temp-273)

HISTORIES
history(Temp-273) at  (0,b/2) (lc/2,b/2) (lc,b/2) (lc/4,b/2)  as "Temperatura C"


END




